#ifndef __CFontReference__
#define __CFontReference__

#include <Basics/CCountedObject.hpp>
#include <Basics/CString.hpp>

//	===========================================================================

using Exponent::Basics::CCountedObject;
using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Fonts
		{
			/**
			 * @class CFontReference CFontReference.hpp
			 * @brief Reference to a font via name
			 *
			 * @date 21/08/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CFontReference.hpp,v 1.3 2007/02/08 21:07:54 paul Exp $
			 */
			class CFontReference : public CCountedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param name The name of the font
				 * @param facename The face name of the font
				 */
				CFontReference(const CString &name, const CString &facename);

				/**
				 * Copy construction
				 * @param reference The font reference to copy
				 */
				CFontReference(const CFontReference &reference);

				/**
				 * Destruction
				 */
				virtual ~CFontReference();

//	===========================================================================

				/**
				 * Assignment operator
				 * @param reference The font reference to copy
				 * @retval CFontReference& A reference to this
				 */
				CFontReference &operator = (const CFontReference &reference);

//	===========================================================================

				/**
				 * Set the name
				 * @param name The name of the font
				 */
				void setName(const CString &name) { m_name = name; }

				/**
				 * Set the filename
				 * @param facename The face name of the font
				 */
				void setFacename(const CString &facename) { m_facename = facename; }

//	===========================================================================

				/**
				 * Get the name
				 * @retval const CString& The name of the font
				 */
				const CString &getName() const { return m_name; }

				/**
				 * Get the filename
				 * @retval const CString& The facename of the font
				 */
				const CString &getFacename() const { return m_facename; }

//	===========================================================================

			protected:

//	===========================================================================

				CString m_name;					/**< The name */
				CString m_facename;				/**< Font face name */

			};
		}
	}
}
#endif	// End of CFontReference.hpp